"""H5 utilities CLI."""

from __future__ import annotations

from typing import TYPE_CHECKING

import typer

from pathfmtools.io.slide_data_store import SlideDataStore

if TYPE_CHECKING:
    from pathlib import Path

app = typer.Typer()


@app.command("delete-tiles")
def delete_tiles(
    root: Path = typer.Option(..., help="Root directory of slide HDF5 files"),
    slide_id: str = typer.Option(..., help="Slide identifier"),
    yes: bool = typer.Option(False, "--yes", help="Confirm deletion without prompt"),
) -> None:
    """Delete tile pixels from a slide's H5, keeping embeddings/metadata."""
    if not yes:
        confirm = typer.confirm(
            f"Delete tiles dataset for slide '{slide_id}' under root '{root}'?",
        )
        if not confirm:
            raise typer.Abort()

    store = SlideDataStore(root).open("a")
    store.delete_tiles(slide_id)
    typer.echo(f"Deleted tiles for slide {slide_id}")


if __name__ == "__main__":
    app()
