"""Embedding models."""

import logging

from pathfmtools.embedding_models.embedding_model import EmbeddingModel
from pathfmtools.embedding_models.registry import (
    get_capabilities,
    get_embedding_model,
    list_available_models,
    register_model,
)

logger = logging.getLogger(__name__)


# Import all model modules to trigger registration
# These imports will cause the @register_model decorators to execute
from pathfmtools.embedding_models import (  # noqa: E402, F401
    conch,
    h_optimus,
    hibou,
    midnight,
    musk,
    phikon,
    uni,
    virchow,
)

# Make key classes available for import
__all__ = [
    "EmbeddingModel",
    "get_capabilities",
    "get_embedding_model",
    "list_available_models",
    "register_model",
]
