"""Centralized schema constants and dtypes."""

from __future__ import annotations

from enum import Enum
from typing import Final

import h5py
import numpy as np

SCHEMA_VERSION: Final[str] = "1.0"


class StoreKeys(str, Enum):
    # Dataset names
    DS_TILES = "tiles"
    DS_TILE_META = "tile_metadata"
    DS_SLIDE_META = "slide_metadata"
    DS_SEG_MASK = "tile_segmentation_mask"

    # Group roots
    TILE_EMBEDDINGS_ROOT = "tile_embeddings"
    TILE_FEATURE_EMBEDDINGS = "feature"
    TILE_ZEROSHOT_EMBEDDINGS = "zeroshot"

    # Tile metadata group names
    TILE_META_TOP_LEFT_X = "top_left_x"
    TILE_META_TOP_LEFT_Y = "top_left_y"
    TILE_META_ROW = "row"
    TILE_META_COL = "col"
    TILE_META_WIDTH = "width"
    TILE_META_HEIGHT = "height"

    SLIDE_META_ID = "slide_id"
    SLIDE_META_WIDTH = "slide_width"
    SLIDE_META_HEIGHT = "slide_height"
    SLIDE_META_MAGNIFICATION = "magnification"
    SLIDE_META_PATCH_SIZE = "patch_size"
    SLIDE_META_SLIDE_FPATH = "slide_fpath"
    SLIDE_META_SEGMENTATION_METHOD = "segmentation_method"
    SLIDE_META_PROP_FOREGROUND = "prop_foreground"


# Dtypes
PATCHES_DTYPE: Final[np.dtype] = np.dtype(np.uint8)
EMBEDDINGS_DTYPE: Final[np.dtype] = np.dtype(np.float16)
SEG_MASK_DTYPE: Final[np.dtype] = np.dtype(np.bool_)
JSON_DTYPE: Final[np.dtype] = h5py.string_dtype(encoding="utf-8")
