"""Domain-specific exceptions for IO and streaming."""

from __future__ import annotations


class DatasetExistsError(RuntimeError):
    """Raised when attempting to create a dataset that already exists."""


class ShapeMismatchError(ValueError):
    """Raised when provided arrays do not match expected shapes/dtypes."""


class FinalizeError(RuntimeError):
    """Raised when finalization/rename fails to publish datasets atomically."""
