"""Profiling tools."""

import logging

import psutil

logger = logging.getLogger(__name__)
PROCESS = psutil.Process()


def log_profiling_info(msg: str) -> None:
    """Log the memory usage of the current process.

    Args:
        msg: Message to log

    """
    process_memory_gb = PROCESS.memory_info().rss / 1024**3
    system_memory_info = psutil.virtual_memory()
    system_memory_free_gb = system_memory_info.available / 1024**3
    system_memory_total_gb = system_memory_info.total / 1024**3
    system_memory_used_pct = system_memory_info.percent
    logger.debug(
        f"{msg}: process memory: {process_memory_gb:.2f}GB, system memory available: "  # noqa: G004
        f"{system_memory_free_gb:.2f}GB/{system_memory_total_gb:.2f}GB "
        f"({system_memory_used_pct}% used)",
    )
