# few_shot_image

## Vision Tasks

### Running the code

**Datasets**
- [miniImageNet](https://mega.nz/#!rx0wGQyS!96sFlAr6yyv-9QQPCm5OBFbOm4XSD0t-HlmGaT5GaiE) (courtesy of [Spyros Gidaris](https://github.com/gidariss/FewShotWithoutForgetting))
- [tieredImageNet](https://drive.google.com/open?id=1nVGCTd9ttULRXFezh4xILQ9lUkg0WZCG) (courtesy of [Kwonjoon Lee](https://github.com/kjunelee/MetaOptNet))
- [domainNet](http://ai.bu.edu/M3SDA/)
- [ImageNet-800](http://image-net.org/challenges/LSVRC/2012/)

### result

#### standard FT
| Backbone  | dataset |  shot  |Accuracy|
|------------|--------|--------|-|
|CLIP-ViT_B32| mini   |    1   |69.39 +- 0.30|
|            |        |    5   |88.39 +- 0.15|
|            | tiered |    1   |61.20 +- 0.37|
|            |        |    5   |80.65 +- 0.27|
|            | domain |    1   |47.72 +- 0.37|
|            |        |    5   |72.82 +- 0.29|
|CLIP-RN50   | mini   |    1   |63.15 +- 0.31|
|            |        |    5   |83.45 +- 0.17|
|            | tiered |    1   |55.77 +- 0.35|
|            |        |    5   |75.28 +- 0.29|
|            | domain |    1   |43.77 +- 0.38|
|            |        |    5   |67.30 +- 0.31|
|DINOv2-ViT  | mini   |    1   |91.07 +- 0.19|
|            |        |    5   |97.32 +- 0.06|
|            | tiered |    1   |82.40 +- 0.30|
|            |        |    5   |93.07 +- 0.16|
|            | domain |    1   |61.84 +- 0.39|
|            |        |    5   |79.63 +- 0.25|
|torchVis-ViT| mini   |    1   |95.28 +- 0.13|
|            |        |    5   |98.33 +- 0.04|
|            | tiered |    1   |86.44 +- 0.27|
|            |        |    5   |94.91 +- 0.12|
|            | domain |    1   |30.93 +- 0.31|
|            |        |    5   |52.14 +- 0.29|
|torchVis-RN50| mini   |    1   |84.10 +- 0.22|
|            |        |    5   |94.81 +- 0.09|
|            | tiered |    1   |74.48 +- 0.33|
|            |        |    5   |88.35 +- 0.19|
|            | domain |    1   |34.10 +- 0.31|
|            |        |    5   |55.08 +- 0.29|

#### Examples
* run multitask finetune
```
python finetune.py \
    --config=configs/clip/mini-imagenet/finetune_ViT.yaml \
    --n_batch_train 200 \
    --n_shot 1 \
    --sample_per_task 150
```
modify `path` in `test.yaml ` as saving model path or add `--path [path]` in command `python test.py`

* run standard finetune
```
python lp_finetune.py --config=configs/clip/mini-imagenet/finetune_ViT_lp.yaml
```
choose different yaml file for datasets and model, modify yaml file accordingly.

* run test
```
python test.py --config=configs/dinov2/domain-net/test.yaml
```
choose different yaml file for datasets and model, modify yaml file accordingly.



## Local data directory
```
datasets/
├── mini-imagenet
│   ├── miniImageNet_category_split_meta_train_limited100.pickle
│   ├── miniImageNet_category_split_meta_train_limited10.pickle
│   ├── miniImageNet_category_split_meta_train_limited20.pickle
│   ├── miniImageNet_category_split_meta_train_limited50.pickle
│   ├── miniImageNet_category_split_meta_train_limited_class16.pickle
│   ├── miniImageNet_category_split_meta_train_limited_class32.pickle
│   ├── miniImageNet_category_split_meta_train_limited_class8.pickle
│   ├── miniImageNet_category_split_test.pickle
│   ├── miniImageNet_category_split_train_phase_test.pickle
│   ├── miniImageNet_category_split_train_phase_train.pickle
│   ├── miniImageNet_category_split_train_phase_val.pickle
│   └── miniImageNet_category_split_val.pickle
```
