from ..baseline import RedTeamingMethod

class DirectRequest(RedTeamingMethod):
    def __init__(self, **kwargs):
        pass
    
    def generate_test_cases(self, behaviors, verbose=False, **kwargs):
        test_cases = {}
        for behavior in behaviors:
            # ========== Behavior meta data ==========
            behavior_dict = behavior
            behavior = behavior_dict['Behavior']
            context_str = behavior_dict['ContextString']
            behavior_id = behavior_dict['BehaviorID']
            if context_str:
                behavior = f"{context_str}\n\n---\n\n{behavior}"
            test_cases[behavior_id] = [behavior]
        return test_cases, {}