# merge_counters.pyx
from libc.stdlib cimport malloc, free

cdef extern from "Python.h":
    PyObject* PyList_GetItem(PyObject* p, Py_ssize_t index) nogil
    Py_ssize_t PyList_Size(PyObject* p) nogil

cdef struct CounterItem:
    int key
    int count

cdef class FastCounter:
    cdef CounterItem* items
    cdef int size

    def __cinit__(self, int size):
        self.size = size
        self.items = <CounterItem*>malloc(size * sizeof(CounterItem))
        if not self.items:
            raise MemoryError()

    def __dealloc__(self):
        if self.items:
            free(self.items)

    cpdef void add(self, list tuples):
        cdef int i
        cdef int n = len(tuples)
        for i in range(n):
            self.items[i].key = tuples[i][0]
            self.items[i].count = tuples[i][1]

    cpdef list sum_counters(self, FastCounter other):
        cdef int i
        for i in range(self.size):
            self.items[i].count += other.items[i].count
        return [(self.items[i].key, self.items[i].count) for i in range(self.size)]

# Setup.py to compile this Cython file
from setuptools import setup
from Cython.Build import cythonize

setup(
    ext_modules = cythonize("merge_counters.pyx")
)
