## Install dependencies

```bash
conda env create -f environment.yml
conda activate redteam
```

## Supervised fine-tuning
First, fine-tune gpt2 model on the initial SFT dataset.

```bash
bash scripts/run_sft.sh
```


## GFlowNet fine-tuning for GPT-2

```bash
bash scripts/run_gpt2.sh
```


## GFlowNet fine-tuning for dolly-v2-7b

```bash
bash scripts/run_dolly.sh
```


## GFlowNet fine-tuning for Gemma-2b-it

```bash
bash scripts/run_gemma.sh
```

## GFlowNet fine-tuning for Llama-2-7b-chat

```bash
bash scripts/run_llama.sh
```


## MLE-smoothing
For gpt2, dolly target model, we set totrain_steps for 2000 and batch_size for 2048. For the other models, we use 1000 and 1024 for train_steps and batch_size, respectively. Note that $\texttt{target\_model} \in \{\texttt{gpt2}, \texttt{dolly}, \texttt{gemma}, \texttt{llama} \}$

```bash
bash scripts/run_mle.sh "target_model" "train_steps" "batch_size"
```


## Transfer experiments
```bash
bash scripts/run_transfer.sh
```
