export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export OUTPUT_DIR="checkpoint/k_unique_10_lr_5e-06_steal_fast_test_clip_score"
export TRAIN_DIR="DATASETS/preprocessed_laion_11k/metadata.csv"


CUDA_VISIBLE_DEVICES="0" accelerate launch --mixed_precision="fp16"  train_unique.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --train_data_dir=$TRAIN_DIR \
  --resolution=512 --backdoor_resolution=512 --center_crop \
  --train_batch_size=4 \
  --gradient_accumulation_steps=1 \
  --gradient_checkpointing \
  --max_train_steps=100000 \
  --learning_rate=5e-06 \
  --max_grad_norm=1 \
  --lr_scheduler="constant" --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --checkpointing_steps=100 \
  --validation_prompt="The Busker" \
  --seed=42 \
  --unique_scale=1.0 \
  --steal_type='k_unique_img' \
  --unique_embedding_path='embedding_folder/dhe_embeddings_length_15000_768.pt' \
  --k_unique=10 \
  --k_shift=0 \
  --freeze_text_encoder \
  --eval_clip_score \
  --step_validation
  #--resume_ckpt='checkpoint/k_unique_100_lr_1e-06_resume/checkpoint-latest/unet.pyt'
  #choices=['all_same','all_null','ten_same','ten_unique','ten_null','normal']
  #--resume_from_checkpoint='checkpoint/full_1280/checkpoint-100'