export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export OUTPUT_DIR="checkpoint/laion-train-laion-concat-50-DHE-emb-lr-5e-06-"
export TRAIN_DIR="DATASETS/preprocessed_laion_11k/metadata.csv"

CUDA_VISIBLE_DEVICES="0,1,2,3,4,5,6,7" accelerate launch --mixed_precision="fp16"  train_unique_concat_multi_gpu.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --train_data_dir=$TRAIN_DIR \
  --resolution=512 --backdoor_resolution=512 --center_crop \
  --train_batch_size=12 \
  --gradient_accumulation_steps=1 \
  --gradient_checkpointing \
  --max_train_steps=100000 \
  --learning_rate=5e-06 \
  --max_grad_norm=1 \
  --lr_scheduler="constant" --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --checkpointing_steps=100 \
  --validation_steps=100 \
  --validation_prompt="The Busker" \
  --seed=42 \
  --unique_scale=1.0 \
  --steal_type='k_unique_img' \
  --unique_embedding_path='embedding_folder/dhe_embeddings_length_15000_768.pt' \
  --k_unique=50 \
  --k_shift=0 \
  --freeze_text_encoder \
  --step_validation \
  --unique_portion=0.5 \
  #--eval_clip_score \
  #--resume_ckpt='checkpoint/8_gpu_5e06_batch_4_acc1_50img_unique_portion_06_linear_decreasing_resume/checkpoint-latest/unet.pyt'
