export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export OUTPUT_DIR="checkpoint_Defense/checkpoint_CBS_duplicate_15_steal_300_defense_100_specific_timestep_998~999_pizza"
export TRAIN_DIR="DATASETS/coco_subset_preprocessed/metadata.csv"
export BACKDOOR_DIR="DATASETS/coco_subset_preprocessed/metadata.csv"

CUDA_VISIBLE_DEVICES="0" accelerate launch --mixed_precision="fp16"  t2i_defense.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --train_data_dir=$TRAIN_DIR \
  --backdoor_data_dir=$BACKDOOR_DIR \
  --resolution=512 --backdoor_resolution=512 --center_crop \
  --train_batch_size=7 \
  --gradient_accumulation_steps=1 \
  --gradient_checkpointing \
  --max_train_steps=100000 \
  --learning_rate=5e-08 \
  --max_grad_norm=1 \
  --lr_scheduler="constant" --lr_warmup_steps=0 \
  --output_dir=${OUTPUT_DIR} \
  --checkpointing_steps=100 \
  --validation_steps=100 \
  --validation_prompt="The Busker" \
  --seed=42 \
  --unique_scale=1.0 \
  --steal_type='k_unique_img_empty_caption' \
  --unique_embedding_path='embedding_folder/uniform_embeddings_length_768_3k_norm.pt' \
  --k_unique=0 \
  --k_shift=0 \
  --step_validation \
  --eval_trigger \
  --freeze_text_encoder \
  --resume_ckpt='checkpoint_CBS/duplicate_15_wo_text_encoder/checkpoint-latest/unet.pyt' \
  --w_reg_weight=100 \
  --forget_caption='a close up of a pizza on a napkin on a table' \
  --forget_image_path='DATASETS/coco_subset_preprocessed/1257.jpg'
  #--eval_clip_score \
  #choices=['all_same','all_null','ten_same','ten_unique','ten_null','normal']
  #--resume_from_checkpoint='checkpoint/full_1280/checkpoint-100'