import subprocess
import sys
import os

# Base script path
script_path = os.path.join(os.path.dirname(__file__), "eval_policy.py")

# List of configurations to run
configurations = [
    #"deneck_draw_#_random",
    "deneck_draw_pentagon_random",
    #"deneck_draw_star_random",
]

# Number of times to run each command
num_runs_per_config = 10

# Iterate through each configuration
for config_name in configurations:
    # Construct the command for the current configuration
    command = ["python", script_path, f"--config-name={config_name}"]
    
    print(f"\n=== Starting Configuration: {config_name} ===")
    print(f"Command: {' '.join(command)}")

    # Run the command for the specified number of times
    for i in range(num_runs_per_config):
        print(f"\n--- Run {i + 1}/{num_runs_per_config} for {config_name} ---")
        try:
            # Stream output directly to terminal rather than capturing it
            result = subprocess.run(command, text=True, check=False)
            
            # Check the return code
            if result.returncode == 0:
                print(f"Run {i + 1} completed successfully (return code 0).")
            else:
                print(f"Run {i + 1} completed with return code {result.returncode}.")
                
        except FileNotFoundError:
            print(f"Error: The command 'python' or the script '{script_path}' was not found.")
            print("Please ensure Python is installed and the script path is correct.")
            sys.exit(1)
        except Exception as e:
            print(f"An unexpected error occurred during run {i + 1} setup or execution: {e}")

    print(f"\n=== Finished {num_runs_per_config} runs for Configuration: {config_name} ===")

print(f"\n--- All configurations processed ---")