import robotic as ry
import sys
import time 

time.sleep(3)

if len(sys.argv) != 2:
    print("Usage: python gripper_move.py <command>")
    print("Commands: 'close' or 'open'")
    sys.exit(1)

commandLineArg = sys.argv[1]  # Get the command from the command line

C = ry.Config()
C.addFile(ry.raiPath('scenarios/pandaSingle.g'))

bot = ry.BotOp(C, True)

if commandLineArg == "close":
    bot.gripperClose(ry._left)
    while not bot.gripperDone(ry._left):
        bot.sync(C, 0.1)
elif commandLineArg == "open":
    bot.gripperMove(ry._left, 0.07)
    while not bot.gripperDone(ry._left):
        bot.sync(C, 0.1)
else:
    print("Invalid command. Use 'close' or 'open'.")
