import glob
import cv2
import numpy as np
import os

def convert_pngs_to_npy():
    # Get all output_*.png files
    image_files = sorted(glob.glob("output_*.png"))

    if not image_files:
        print("No output_*.png files found.")
        return

    for img_path in image_files:
        # Load image (as grayscale or RGB depending on your case)
        image = cv2.imread(img_path, cv2.IMREAD_GRAYSCALE)  # Change to IMREAD_COLOR if needed

        # Create .npy filename
        base_name = os.path.splitext(img_path)[0]
        npy_path = base_name + ".npy"

        # Save as .npy
        np.save(npy_path, image)
        print(f"Saved {npy_path}")

if __name__ == "__main__":
    convert_pngs_to_npy()
