#include <iostream>
#include "empirical_error.h"

vector<pair<WeightedSet, double> > testdata;

void GenerateTestData(const WeightedSet &P){
	sampler S;
	vector<double> weight;
	for(int i = 0; i < N; i++) weight.push_back(1);
	S.init(weight);
	for(int i = 1; i <= Tt; i++){
		WeightedSet X;
		for(int j = 0; j < K; j++){
			X.push_back(P[S.sample()]);
		}
		testdata.push_back(make_pair(X, Cost(P, X, 2)));
	}
}

double EmpiricalError(const WeightedSet &points, const WeightedSet &Coreset, int z, int k){
	double err = 0;
	for(int i = 0; i < (int)testdata.size(); i++){
		double ans = testdata[i].second, out = Cost(Coreset, testdata[i].first, z);
		err = max(err, fabs(ans - out) / ans * 100);
	}
	return err;
}