//Experiment 2: speeding up kernelized K-Means++

#include <cstdio>
#include <algorithm>
#include <iostream>
#include <vector>
#include <cmath>
#include "parameters.h"
#include "parameters2.h"
#include "tools.h"
#include "kernel.h"
#include "kmeans.h"
#include "coreset.h"
#include "empirical_error.h"

using namespace std;

int main(){
	freopen(filename, "r", stdin);
	WeightedSet P;
	for(int i = 0; i < N; i++){
		DataPoint x; x.resize(DIM);
		for(int j = 0; j < DIM; j++){
			scanf("%lf", &x[j]);
		}
		P.push_back(make_pair(x, 1));
	}
	fclose(stdin);
	double pure_kmeans_ave_time = 0;
	double pure_kmeans_ave_cost = 0;
	double coreset_kmeans_ave_time = 0;
	double coreset_kmeans_ave_cost = 0;
	double coreset_ave_time = 0;
	double kmeans_ave_time = 0;
	double best_cost = 1e90;
	printf("Parameters:\n");
	printf("\tDataSet: Name = \"%s\"; N = %d; Dimension = %d; Weight = 1.\n", DS, N, DIM);
	if(Kernel == RBFKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = RBFKernel with sigma = %lf\n",CORESET_SIZE, K, Z, SIGMA);
	}
	else if(Kernel == polyKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = polynomial Kernel with (c, d) = (%d, %d)\n", CORESET_SIZE, K, Z, cst, deg);
	}
	puts("");
	for(int i = 1; i <= T; i++){
		double tk;
		printf("Testing Round #%d:\n", i);

		tk = clock();
		WeightedSet coreset = Coreset(P, CORESET_SIZE, K, Z, 1);
		double coreset_time = ((double)clock() - tk) /(double)CLOCKS_PER_SEC;

		tk = clock();
		vector<Center> coreset_kmeans = Kmeans(coreset, K, Z);
		double kmeans_time = ((double)clock() - tk) / (double)CLOCKS_PER_SEC;
		double coreset_kmeans_cost = Cost(P, coreset_kmeans, Z);

		coreset_kmeans_ave_time += coreset_time + kmeans_time;
		coreset_ave_time += coreset_time;
		kmeans_ave_time += kmeans_time;
		coreset_kmeans_ave_cost += coreset_kmeans_cost;
		best_cost = min(best_cost, coreset_kmeans_cost);
		printf("Coreset Kmeans Running Time: %lf ; Objective Value: %lf ;\n", coreset_time + kmeans_time, coreset_kmeans_cost);
		printf("\t\tWhere Coreset Time: %lf ; Kmeans Time : %lf \n", coreset_time, kmeans_time);
	}
	pure_kmeans_ave_time /= T; pure_kmeans_ave_cost /= T;
	coreset_kmeans_ave_cost /= T; coreset_kmeans_ave_time /= T;
	coreset_ave_time /= T; kmeans_ave_time /= T;
	puts("");
	printf("Parameters:\n");
	printf("\tDataSet: Name = \"%s\"; N = %d; Dimension = %d; Weight = 1.\n", DS, N, DIM);
	if(Kernel == RBFKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = RBFKernel with sigma = %lf\n",CORESET_SIZE, K, Z, SIGMA);
	}
	else if(Kernel == polyKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = polynomial Kernel with (c, d) = (%d, %d)\n", CORESET_SIZE, K, Z, cst, deg);
	}
	printf("Total Result:\n");
	printf("Coreset Kmeans Average Running Time: %lf ; Best Objective Value: %lf ;\n", coreset_kmeans_ave_time, best_cost);
	printf("\t\t Where Coreset Average Time: %lf ; Kmeans Average Time : %lf \n", coreset_ave_time, kmeans_ave_time);

}