#include <iostream>
#include "tools.h"
#include "kmeans.h"

WeightedSet Initialize(const WeightedSet &points, int k, int z){ //K-means++'s initialization
	WeightedSet C;
	sampler S;
	vector<double> weights;
	for(int i = 0; i < points.size(); i++)
		weights.push_back(points[i].weight);
	S.init(weights);
	C.push_back(points[S.sample()]);
	for(int i = 1; i < k; i ++){
		for(int j = 0; j < points.size(); j++)
			weights[j]=points[j].weight * d(points[j].datapoint, C, z);
		S.init(weights);
		C.push_back(points[S.sample()]);
	}
	return C;
}

vector<Center> Kmeans(const WeightedSet &points, int k, int z){
	WeightedSet I = Initialize(points, k, z);
	vector<Center> C;
	for(int i = 0; i < I.size(); i++){
		Center cur; cur.push_back(make_pair(I[i].datapoint, 1));
		C.push_back(cur);
	}
	while(1){
		vector<double> norm;
		for(int i = 0; i < C.size(); i++)
			norm.push_back(Norm(C[i]));
		vector<Center> C_cur;
		C_cur.resize(k);
		for(int i = 0; i < points.size(); i++){
			int NN = Nearest(points[i].datapoint, C, norm, z);
			C_cur[NN].push_back(points[i]);
		}
		for(int i = 0; i < k; i++){
			double sum = 0;
			for(int j = 0; j < C_cur[i].size(); j++)
				sum += C_cur[i][j].weight;
			for(int j = 0; j < C_cur[i].size(); j++)
				C_cur[i][j].weight /= sum;
		}
		if(isEqual(C, C_cur, k)) break;
		C = C_cur;
	}
	return C;
}