#include <iostream>
#include "coreset.h"



WeightedSet Coreset(const WeightedSet &points, int CoresetSize, int k, int z, int Tinit = 1){
/*
Input:
	points - Input dataset
	CoresetSize - Size of coreset
	k,z - Clustering parameter
Output:
	Coreset
*/
	sampler S;
	WeightedSet C_apx = Initialize(points, k, z);
	double mincost = Cost(points, C_apx, z);
	for(int i = 1; i <= Tinit; i++){
		WeightedSet C_cur = Initialize(points, k, z);
		double cost = Cost(points, C_cur, z);
		if(cost < mincost){
			mincost = cost;
			C_apx = C_cur;
		}
	}
	vector<double> sigma;
	vector<double> C_weight;
	vector<int> NN;
	for(int i = 0; i < points.size(); i++) 
		NN.push_back(Nearest(points[i].datapoint, C_apx, z));
	for(int i = 0; i < C_apx.size(); i++) C_weight.push_back(0);
	for(int i = 0; i < points.size(); i++){
		C_weight[NN[i]] += points[i].weight;
	}
	double cost = Cost(points, C_apx, z), sum = 0;
	for(int i = 0; i < points.size(); i++){
		double s = d(points[i].datapoint, C_apx, z) / cost + 1.0 / C_weight[NN[i]];
		sigma.push_back(points[i].weight * s);
		sum += points[i].weight * s;
	}
	for(int i = 0; i < points.size(); i++)
		sigma[i] /= sum;
	S.init(sigma);
	WeightedSet coreset;
	for(int i = 0; i < CoresetSize; i++){
		int cur = S.sample();
		coreset.push_back(points[cur]);
		coreset[i].weight /= sigma[cur] * CoresetSize; 
	}
	return coreset;
}

WeightedSet UniformCoreset(const WeightedSet &points, int CoresetSize){
	sampler S;
	vector<double> pd;
	for(int i = 0; i < points.size(); i++) pd.push_back(1);
	S.init(pd);
	WeightedSet coreset;
	for(int i = 0; i < CoresetSize; i++){
		coreset.push_back(points[S.sample()]);
		coreset[i].weight /= CoresetSize / (double)points.size();
	}
	return coreset;
}