//Experiment 1: size and empirical error tradeoff

#include <cstdio>
#include <algorithm>
#include <iostream>
#include <vector>
#include <cmath>
#include "parameters.h"
#include "parameters1.h"
#include "tools.h"
#include "kernel.h"
#include "kmeans.h"
#include "coreset.h"
#include "empirical_error.h"

using namespace std;

int main(){
	sampler S;
	FILE *INFILE = fopen(filename, "r");
	WeightedSet P;
	for(int i = 0; i < N; i++){
		DataPoint x; x.resize(DIM);
		for(int j = 0; j < DIM; j++){
			fscanf(INFILE, "%lf", &x[j]);
		}
		P.push_back(make_pair(x, 1));
	}
	GenerateTestData(P);
	vector<double> err_coreset, err_ucoreset;
	double ave_coreset_err = 0, worst_coreset_err = 0, best_coreset_err = -1;
	double ave_ucoreset_err = 0, worst_ucoreset_err = 0, best_ucoreset_err = -1;
	double ave_coreset_time = 0, worst_coreset_time = 0;
	double ave_ucoreset_time = 0, worst_ucoreset_time = 0;

	printf("Parameters:\n");
	printf("\tDataSet: Name = \"%s\"; N = %d; Dimension = %d; Weight = 1.\n", DS, N, DIM);
	if(Kernel == RBFKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = RBFKernel with sigma = %lf\n",CORESET_SIZE, K, Z, SIGMA);
	}
	else if(Kernel == polyKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = polynomial Kernel with (c, d) = (%d, %d)\n", CORESET_SIZE, K, Z, cst, deg);
	}

	puts("");
	for(int t = 1; t <= T; t++){
		int tk = clock();
		WeightedSet coreset = Coreset(P, CORESET_SIZE, K, Z, 3);
		double coreset_time = (clock() - tk) / (double)CLOCKS_PER_SEC;
		ave_coreset_time += coreset_time;
		worst_coreset_time = max(worst_coreset_time, coreset_time); // record running time

		tk = clock();
		WeightedSet ucoreset = UniformCoreset(P, CORESET_SIZE);

		double ucoreset_time = (clock() - tk) / (double)CLOCKS_PER_SEC;
		ave_ucoreset_time += ucoreset_time;
		worst_ucoreset_time = max(worst_ucoreset_time, ucoreset_time); // record running time

		double coreset_err = EmpiricalError(P, coreset, Z, K), ucoreset_err = EmpiricalError(P, ucoreset, Z, K);

		ave_coreset_err += coreset_err;
		worst_coreset_err = max(worst_coreset_err, coreset_err);
		if(best_coreset_err < 0 || coreset_err < best_coreset_err) best_coreset_err = coreset_err;

		ave_ucoreset_err += ucoreset_err;
		worst_ucoreset_err = max(worst_ucoreset_err, ucoreset_err);
		if(best_ucoreset_err < 0 || ucoreset_err < best_ucoreset_err) best_ucoreset_err = ucoreset_err;

		err_coreset.push_back(coreset_err);
		err_ucoreset.push_back(ucoreset_err);

		printf("Testing Round #%d:\n", t);
		printf("        \tEmpiricalErr(%%)\tRunningTime(s)\n");
		printf("Coreset \t%lf\t%lf\n", coreset_err, coreset_time);
		printf("Ucoreset\t%lf\t%lf\n", ucoreset_err, ucoreset_time);
		puts("");
	}
	ave_coreset_err /= T; ave_ucoreset_err /= T;
	ave_coreset_time /= T; ave_ucoreset_time /= T;
	double coreset_var = 0, ucoreset_var = 0;
	for(int i = 0; i < T; i ++){
		coreset_var += Pow(err_coreset[i] - ave_coreset_err, 2);
		ucoreset_var += Pow(err_ucoreset[i] - ave_ucoreset_err, 2);
	}
	coreset_var /= T; ucoreset_var /= T;
	printf("Parameters:\n");
	printf("\tDataSet: Name = \"%s\"; N = %d; Dimension = %d; Weight = 1.\n", DS, N, DIM);
	if(Kernel == RBFKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = RBFKernel with sigma = %lf\n",CORESET_SIZE, K, Z, SIGMA);
	}
	else if(Kernel == polyKernel){
		printf("\tAlgorithm: Coreset Size = %d; k = %d; z = %d; Kernel function = polynomial Kernel with (c, d) = (%d, %d)\n", CORESET_SIZE, K, Z, cst, deg);
	}
	puts("");
	printf("Total Result:\n");
	printf("        \tAverageErr(%%)\tWorstErr(%%)\tBestErr(%%)\tVariance\tAverageTime(s)\n");
	printf("Coreset \t%lf\t%lf\t%lf\t%lf\t%lf\n", ave_coreset_err, worst_coreset_err, best_coreset_err, coreset_var, ave_coreset_time);
	printf("Ucoreset \t%lf\t%lf\t%lf\t%lf\t%lf\n", ave_ucoreset_err, worst_ucoreset_err, best_ucoreset_err, ucoreset_var, ave_ucoreset_time);
}
