#include <iostream>
#include "parameters3.h"
#include "kernel.h"

double Ed(const DataPoint &x, const DataPoint &y){ //Euclidean distance
	double sum = 0;
	for(int i = 0; i < DIM; i++)
		sum += (x[i] - y[i]) * (x[i] - y[i]);
	return sqrt(sum);
}

double InnerProduct(const DataPoint &x, const DataPoint &y){
	double sum = 0;
	for(int i = 0; i < DIM; i++)
		sum += x[i] * y[i];
	return sum;
}

double polyKernel(const DataPoint &x, const DataPoint &y){
	return Pow(InnerProduct(x, y) + cst, deg);
}

double RBFKernel(const DataPoint &x, const DataPoint &y){ //Radial basis function kernel
	return exp(-Pow(Ed(x, y), 2) / 2 / SIGMA / SIGMA);
}

#ifdef SPCETRAL_CLUSTERING
double *A;

void SpectralKernel_init(double *D, int n){
	for(int i = 0; i < n; i++) A[i] = D[i];
}

double SpectralKernel(const DataPoint &x,const DataPoint &y){
	return A[index(x)] * A[index(y)] * Similarity(x, y);
}
#endif

double Norm(const Center &c){
	double sum = 0;
	for(int i = 0; i < c.size(); i++)
		for(int j = 0; j <c.size(); j++)
			sum += c[i].weight * c[j].weight * Kernel(c[i].datapoint, c[j].datapoint);
	return sum;
}

bool isEqual(const vector<Center> &C1, const vector<Center> &C2, int k){
	for(int i = 0; i < k; i++){
		if(C1[i].size() != C2[i].size()) return false;
		for(int j = 0; j < C1[i].size(); j++)
			if(C1[i][j].datapoint != C2[i][j].datapoint) return false;
	}
	return true;
}

//distance
double d(const DataPoint &x,DataPoint y, int z){ //Calculate distance between two datapoints
	return Pow(sqrt(Kernel(x,x) + Kernel(y,y) - 2 * Kernel(x,y)),z);
}

double d(const DataPoint &x, const WeightedSet & C, int z){ //Calculate distance between a datapoint and a set 
	double mind = d(x, C[0].datapoint, z);
	for(int i = 1; i < C.size(); i++)
		mind = min(mind, d(x, C[i].datapoint, z));
	return mind;
}

double d_(const DataPoint &x, const Center &c, double norm, int z){ //Calculate distance between a datapoint and a k-means center
	double dis = Kernel(x, x) + norm;
	for(int i = 0; i < c.size(); i++)
		dis -= 2 * c[i].weight * Kernel(x, c[i].datapoint);
	return Pow(sqrt(dis), z);
}

int Nearest(const DataPoint &x, const WeightedSet &C, int z){
	double mind = d(x, C[0].datapoint, z); int ans = 0;
	for(int i = 1; i < C.size(); i++){
		if(d(x, C[i].datapoint, z) < mind){
			mind = d(x, C[i].datapoint, z);
			ans = i;
		}
	}
	return ans;
}

int Nearest(const DataPoint &x, const vector<Center> &C, const vector<double> &norms, int z){
	double mind; int ans = -1;
	for(int i = 0; i < C.size(); i++){
		if(C[i].size() == 0) continue;
		double cur = d_(x, C[i], norms[i], z);
		if(cur < mind || ans == -1){
			mind = cur;
			ans = i;
		}
	}
	return ans;
}

double Cost(const WeightedSet & points, const WeightedSet & C, int z){
	double cost = 0;
	for(int i = 0; i < points.size(); i ++){
		cost += points[i].weight * d(points[i].datapoint, C, z);
	}
	return cost;
}

double Cost(const WeightedSet &points, vector<Center> &C, int z){
	double sum = 0;
	vector<double> norm;
	for(int i = 0; i < C.size(); i++)
		norm.push_back(Norm(C[i]));
	for(int i = 0; i < points.size(); i++){
		int nearest_c = Nearest(points[i].datapoint, C, norm, z);
		sum += points[i].weight * d_(points[i].datapoint, C[nearest_c], norm[nearest_c], z);
	}
	return sum;
}
