#ifndef OUR_KERNEL
#define OUR_KERNEL
#include "tools.h"
#include "parameters.h"

typedef vector<double> DataPoint; //Type of input datapoint
typedef vector<pair<DataPoint, double> > WeightedSet; 
typedef vector<pair<DataPoint, double> > Center; //A k-means center is a linear combination of datapoint.

double Ed(const DataPoint &x, const DataPoint &y); //Calculate euclidean distance
double InnerProduct(const DataPoint &x, const DataPoint &y); //Caclulate inner product
double Norm(const Center &c); //Calculate the norm of a k-means center
bool isEqual(const vector<Center> &C1, const vector<Center> &C2, int k); //Check whether two sets of k-means centers are the same

//kernel function
double polyKernel(const DataPoint &x, const DataPoint &y);
double RBFKernel(const DataPoint &x, const DataPoint &y);

void SpectralKernel_init(double *D, int n);
double SpectralKernel(const DataPoint &x,const DataPoint &y);

double d(const DataPoint &x,DataPoint y, int z); //Calculate distance between two datapoints in the feature space
double d(const DataPoint &x, const WeightedSet & C, int z); //Calculate distance between a datapoint and a set in the feature space
double d_(const DataPoint &x, const Center &c, double norm, int z); //Calculate distance between a datapoint and a k-means center in the feature space

int Nearest(const DataPoint &x, const WeightedSet &C, int z); //Find the nearest point in a weighted set C to x
int Nearest(const DataPoint &x, const vector<Center> &C, const vector<double> &norms, int z); //Find the nearest k-means center to x

double Cost(const WeightedSet & points, const WeightedSet & C, int z); //Calculate the cost in (2) in the paper
double Cost(const WeightedSet &points, vector<Center> &C, int z);

#endif
