# Step_Tagging_paper
Step-Tagging: Toward controlling the generation of Language Reasoning Models through step monitoring

![Alt text](assets/step_tagger.png)

## TL;DR
This project introduces the **Step-Tagging** framework, a lightweight text-classifier module that monitor and annotate the reasoning steps of LRMs. In addition, we introduce a taxonomy of reasoning steps, encompasing 14 categories, including early-stage behaviors such as ***Problem Re-statement***, mid-level reasoning like ***Verification*** and ***Exploration*** and late-stage steps including ***Final Conclusion***. We also built an early-stopping framework that dynamically stops token generation based on reasoning steps types and counts, calibrated on the problem complexity. Tested on 3 LRMs across 2 mathematical reasoning datasets, our early-stopping criteria achieved up to 30-40% token reduction, while maintaining a comparable accuracy.

### Contributions:
- Taxonomy of reasoning steps
- Lightweight text-classification module for reasoning step annotation
- Early-stopping criteria based on steps types and counts of reasoning steps

### Models supported:
- [deepseek-ai/DeepSeek-R1-Distill-Llama-8B](https://huggingface.co/deepseek-ai/DeepSeek-R1-Distill-Llama-8B)
- [deepseek-ai/DeepSeek-R1-Distill-Qwen-14B](https://huggingface.co/deepseek-ai/DeepSeek-R1-Distill-Qwen-14B)
- [Qwen/QwQ-32B](https://huggingface.co/Qwen/QwQ-32B)

### Step-Tagging and Baselines:
- Standard inference of models
- Prompt guided $\mathcal{P}_{\text{guided}}$ inferences (system and user prompt instruction, zero-shot and few-shots)
- Step-split and anotations
- Early-Stopping criteria
- Ideal Early-Stopping algorithm 
- Training pipeline for Lightweight Step-Tagging module

## Directory Structure

```
├── assets/                             # Assets and Figures
├── data/                          
│   ├── GSM8K/                          # Mathematical reasoning datasets (train and test splits)
│   │   ├── GSM8K_test.jsonl 
│   │   └── GSM8K_train.jsonl        
│   ├── MATH500/
│   │   ├── MATH500_test.jsonl 
│   │   └── MATH500_train.jsonl  
│   └── source.txt
│
├── src/
│   ├── early_stopping/      
│   │   ├── early_stopping.ipynb                      
│   │   └── utils.py        
│   │    
│   ├── lrm_inference/  
│   │   ├── infer_LRMs.py                      
│   │   └── utils.py   
│   │
│   ├── step_annotation/                     
│   │   └── split_and_annotate.ipynb  
│   │
│   ├── step_tagging_training/      
│   │   ├── training.py                      
│   │   └── utils.py    
│
└── README.md                    
```

