# ------------------------ Prompt Examples (for Few-Shots) ------------------------

FS_1 = "Wait, let me double-check. If I plug in x = -3 into the denominator, (-3)^2 + (-3) -6 = 9 -3 -6 = 0. Yep, that works. For x =2: 2^2 +2 -6 =4 +2 -6=0. Correct. So both roots are valid. \n\n"

FS_2 = "Therefore, the graph of y=2\/(x\u00b2 +x -6) has vertical asymptotes at x= -3 and x=2, so that's two vertical asymptotes. \n\nI don't think there's any chance that I made a mistake here, but maybe I should check by graphing the function or plugging in values close to -3 and 2 to see if the function does go to infinity."

FS_3 = "Another test with n=3. Let's compute manually. \n\nAll non-empty subsets:\n\nSingle elements: {1}, {2}, {3} with sums 1,2,3.\n\nPairs: {1,2} \u2192 2-1=1; {1,3}\u21923-1=2; {2,3}\u21923-2=1.\n\nTriple: {1,2,3} \u21923 -2 +1=2.\n\nTotal sum: 1+2+3 +1+2+1 +2 = 12.\n\nUsing the formula: contributions from each k:\n\nk=3: 3*2^{2}*1= 3*4=12. \n\nk=1 and k=2 contribute 0. \n\nSo total sum 12, which matches. \n\n"

# ------------------------ Prompt Construction ------------------------

def build_conversation(question: str, prompt_type: str):
    """
    Return the conversation to input to the LRM for inference.
    
    Arguments
    -------------------
    - question: str
    User question from reasoning datasets (MATH500 or GSM8K for example).

    - prompt_type: str, choices -> [none, UP-ZS, SP-ZS, SP-FS1, SP-FS3]
    Inference settings. We support:
        - Standard inference (none)
        - User-prompt / Zero-Shot (UP-ZS)
        - System-prompt / Zero-Shot (UP-ZS)
        - System-prompt / Few-Shot with 1 example (SP-FS1)
        - System-prompt / Few-Shot with 3 example (SP-FS3)

    Return
    -------------------
    - conversation: list
    List of dictionary containing the input context to input to the LRM to perform the inference.
    """


    if prompt_type == "none":
        return [{"role": "user", "content": question}]
    elif prompt_type == "UP-ZS":
        return [{"role": "user", "content": f"Please do not reason extensively, be succinct, and put your final answer within \\boxed{{}}. {question}"}]
    elif prompt_type == "SP-ZS":
        return [
            {"role": "system", "content": "Respond concisely and confidently. Skip validations and over-verification steps."},
            {"role": "user", "content": question}
        ]
    elif prompt_type == "SP-FS1":
        return [
            {"role": "system", "content": f"Respond concisely and confidently. Skip validations and over-verification steps. Here is an example: \n Example 1: {FS_1}"},
            {"role": "user", "content": question}
        ]
    elif prompt_type == "SP-FS3":
        return [
            {"role": "system", "content": f"Respond concisely and confidently. Skip validations and over-verification steps. Here are some examples: \n Example 1: {FS_1} \n Example 2: {FS_2} \n Example 3: {FS_3}"},
            {"role": "user", "content": question}
        ]
    else:
        raise ValueError(f"Unknown prompt_type: {prompt_type}")