# TRUST: Transformer-based Reconstruction Using Skip Connections for Optical Image Reconstruction

## 📖 Overview

This repository contains the official implementation of **TRUST** (Transformer-based Reconstruction Using Skip Connections), a novel deep learning approach for optical image reconstruction. Our method combines Vision Transformers (ViT) with U-Net architecture through strategic skip connections to achieve superior reconstruction quality while minimizing hallucination artifacts.

## 🛠️ Installation

### Environment Setup

1. **Create conda environment**
   ```bash
   conda env create -f code_environment.yml
   conda activate optics_recon
   ```

## 🚀 Training

Navigate to the `optics_recon_project` directory and run the following commands to train different models:

### 1. Train Restormer Model
```bash
python restormer_ddp.py
```

### 2. Train UNet Model  
```bash
python unet_ddp.py
```

### 3. Train TransUNet Model
```bash
python transunet_ddp.py
```

### 4. Train TRUST Model (Our Method)
```bash
python trust_ddp.py
```

## 📊 Evaluation

After training, evaluate any model using:

```bash
python eval.py
```

The pretrained model can be download here
https://bit.ly/43IeImg

The evaluation script provides comprehensive metrics including PSNR, SSIM, MAE, MSE, FPR (False Positive Regions), and inference time analysis with statistical variance calculations. You are welcome to look inside the evaluation code to see what model you want to evaluate.


### Due to data privacy concerns related to the optics system and the data size, we are unable to upload the full dataset at this time and there are only limit data inside to show. However, feel free to reach out to us in the future.


## 📎 Appendix

### Extended Experimental Results

The appendix contains additional experimental details, extended comparison tables, ablation study results, and computational analysis that supplement the main paper findings. This includes detailed statistical analysis, model architecture comparisons, and comprehensive evaluation metrics across different test scenarios.

