export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export HF_DATASETS_CACHE="$HOME/.cache/huggingface/datasets"
DATASET=$1
OUTPUT_DIR=$2

DEEPSPEED_TIMEOUT=120 deepspeed --master_port=19901 src/train.py \
    --deepspeed ds_config/ds_config_3.json \
    --stage sft \
    --model_name_or_path "./qwen2.5-7b-instruct" \
    --dataset $DATASET\
    --interleave_probs "1.0" \
    --do_train \
    --mix_strategy "interleave_over" \
    --template "qwen"  \
    --finetuning_type full \
    --output_dir "./output/${OUTPUT_DIR}" \
    --overwrite_output_dir \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 8 \
    --lr_scheduler_type cosine \
    --logging_steps 1 \
    --learning_rate 1e-5 \
    --warmup_ratio 0.02 \
    --num_train_epochs 1 \
    --plot_loss \
    --bf16 \
    --save_only_model \
    --save_safetensors False \
    --preprocessing_num_workers 8 \
    --trust_remote_code True \
    --ts_inputs \
    --freeze_ts_encoder False \
