# Instructions to replicate our experiments

## 1. Setup a python environment
Create a new python 3 environment and install the required packages with the following:
```bash
conda create -n my_env
conda activate my_env
conda config --env --add channels conda-forge
conda install numpy scikit-learn matplotlib pandas tqdm scipy -y
pip install hdf5storage
pip install stag

````
Then install pytorch using one of the recommended commands found here: https://pytorch.org/get-started/locally/. For example:
```bash
conda install pytorch torchvision torchaudio pytorch-cuda=11.8 -c pytorch -c nvidia
```

Now we need to compile the rust library that implements coreset sampling. If you haven't installed the rust toolchain, do so with the following:
```bash
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh # see https://www.rust-lang.org/tools/install for non-linux systems
```
Then build the rust library with
```bash
pip install maturin
cd rust && maturin develop --release
```

## Running the experiments
To run each experiment execute the following from the main directory:
```bash
python main.py exp1 && python main.py plotexp1 #experiment 1
python main.py exp2 && python main.py plotexp2 #experiment 2
python main.py exp3 && python main.py plotexp1 #experiment 3
```
The results are in results/
<!-- show the picture in the results folder -->

![exp1](results/coreset_runtime_comparison.png "Exp1")
![exp1](results/exp2_har_experiment_results.png "Exp2 har")
![exp1](results/exp2_letter_experiment_results.png "Exp2 letter")
![exp1](results/exp2_mnist_784_experiment_results.png "Exp2 mnist")
![exp1](results/exp2_pendigits_experiment_results.png "Exp2 pendigits")
![exp1](results/exp3_synthetic_experiment_results.png "Exp3")





