use criterion::{black_box, criterion_group, criterion_main, Criterion, BenchmarkId};
use ndarray::Array1;
use fast_kernel_coreset_sampling::{improved_coreset, load_sparse_matrix};

#[allow(non_snake_case)]
fn criterion_benchmark(c: &mut Criterion) {
    let mut group = c.benchmark_group("bench_from_file_group");

    // Perform the setup outside the benchmark iteration
    let path = "friendster_graph.npz";
    let (data, indices, indptr, nnz_per_col,  W, shape, _num_clusters) = load_sparse_matrix(path).unwrap();
    let n = shape.0;
    let clusters = 5000;
    let coreset_size = 1_000_000;
    let data = Array1::from(data);
    let indices = Array1::from(indices);
    let indptr = Array1::from(indptr);
    let nnz_per_col = Array1::from(nnz_per_col);
    let W = Array1::from(W);

    group.bench_function(BenchmarkId::new("bench_from_file", "specific_part"), |b| {
        b.iter(|| {
            let (_, _) = improved_coreset(
                black_box(clusters),
                black_box(n),
                black_box(coreset_size),
                black_box(data.view()),
                black_box(indices.view()),
                black_box(indptr.view()),
                black_box(nnz_per_col.view()),
                black_box(W.view()),
                Some(true)
            );
        });
    });

    group.finish();
}

fn configure_criterion() -> Criterion {
    Criterion::default()
        .sample_size(10)
        // .measurement_time(std::time::Duration::from_secs(50))
}

criterion_group! {
    name = benches;
    config = configure_criterion();
    targets = criterion_benchmark
}
criterion_main!(benches);