# Multi-task Self-supervised GNNs Enable Stronger Task Generalization

This code repository contains code for ParetoGNN. 

To reproduce our experiment, you need to first run the python code ```hetero_graph_gen.py``` to general the DGL graphs for heterophilous graphs (i.e., Chameleon, Actor, and Squirrel) and ```link_gen.py``` to prepare training/validation/testing splits for the evaluation on link prediciton.

You can finish these two steps by simply run commands as follows:

```
python hetero_graph_gen.py
python link_gen.py
```

Then to conduct multi-task self-supervised learning, we have prepared bash scripts in the ```bash``` directory. Training a ParetoGNN can be done by:

```
cd bash

\\ to generate node embeddings for node-level tasks like node classification, node clustering, and partition prediction
bash ssnc_{dataset}.sh <GPU_ID> 

\\ to generate node embeddings for link prediction
bash link_{dataset}.sh <GPU_ID> 
```

The node embeddings and the final model will be saved in the ```bash``` directory.

To conduct evaluation, please run our evaluation script:

```
python eval.py --data {dataset} --embedding_path_node {path_to_emb_node} --embedding_path_link {path_to_emb_link}
```

The package we use include:
    
    * DGL 0.9.0
    * PyTorch 1.12.0
    * ogb 1.3.4
