from benchopt.base import BaseObjective
from benchopt import safe_import_context

with safe_import_context() as import_ctx:
    import numpy as np


class Objective(BaseObjective):
    name = "Test objective requirements"

    install_cmd = 'conda'
    requirements = []

    def __init__(self):
        pass

    def set_data(self, X):
        self.X = X

    def get_one_solution(self):
        return np.zeros(self.X.shape[1])

    def compute(self, beta):
        Xb = self.X @ beta
        return .5 * Xb.T.dot(Xb)

    def to_dict(self):
        return dict(X=self.X)
