# Spiking Neuron as Discrete Gating for Long-Term Memory Tasks

This is the official code for the paper. Our proposed module is named as LIFGate in the code, referring to "Leaky Integrate-and-Fire as Gating".

## Installation

We use python 3.8+ for all experiments, but the requirement of Memory-RL and POPGym is different, we list them separately in **requirements_memrl.txt** and **requirements_popgym.txt**.

If popgym is not installed, follow the guide in [GitHub - proroklab/popgym: Partially Observable Process Gym](https://github.com/proroklab/popgym).

## Reproducing the Results

### Passive Visual Match

To run Passive Visual Match with a memory length of 250 with LIFGate-based agent:

```shell
cd Memory-RL
python main.py \
    --config_env configs/envs/visual_match.py \
    --config_env.env_name 250 \
    --config_rl configs/rl/sacd_default.py \
    --shared_encoder --freeze_critic \
    --train_episodes 4000 \
    --config_seq configs/seq_models/lifgate_cnn.py \
    --config_seq.sampled_seq_len -1 \
    --config_seq.model.seq_model_config.n_layer 1 \
    --save_dir ../results_memrl
```

To run experiments with other sequence models, please change the configuration of  --config_seq.

To run the task with a memory leagth of 500, --config_env.env_name should be set to 500, and --train_episodes should be set to 2000.

### POPGym

To run AutoencodeEasy with LIFGate-based agent:

```shell
cd POPGym
python train_popgym.py --model lifgate --h 1024 --env AutoencodeEasy
```

### Pybullet

To run our method TD3 (*shared* actor and critic) on PyBullet Cheetah-P with sampled sequence length of 64:

```shell
cd Memory-RL-pybullet
python main.py \
    --config_env configs/envs/pomdps/pybullet_p.py \
    --config_env.env_name cheetah \
    --config_rl configs/rl/td3_default.py \
    --config_seq configs/seq_models/lifgate_default.py \
    --config_seq.sampled_seq_len 64 \
    --train_episodes 1500 \
    --shared_encoder --freeze_all \
```

### Plotting the Temporal Saliency Curve

First, choose the sequence model you want to plot the curve, and do the training:

```python
cd Memory-RL
python main.py \
    --config_env configs/envs/visual_match.py \
    --config_env.env_name 250 \
    --config_rl configs/rl/sacd_default.py \
    --shared_encoder --freeze_critic \
    --train_episodes 1000 \
    --config_seq configs/seq_models/lifgate_cnn.py \
    --config_seq.sampled_seq_len -1 \
    --config_seq.model.seq_model_config.n_layer 1 \
    --plot_saliency
```

Similar to the above code, but set the --plot_saliency flag. This will output an extra csv file in the logging directory. We can then plot the result with the code in Memory-RL/plot_saliency.py.

## Acknowledgement

This code is largely based on prior works:

[GitHub - twni2016/Memory-RL: When Do Transformers Shine in RL? Decoupling Memory from Credit Assignment, NeurIPS 2023 (oral)](https://github.com/twni2016/Memory-RL)

[GitHub - CTP314/TFPORL](https://github.com/CTP314/TFPORL)

[GitHub - thaihungle/SHM: Source code for Stable Hadamard Memory](https://github.com/thaihungle/SHM)
