import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
from matplotlib.transforms import ScaledTranslation


def plot_n_circles():
    input_path = "visualizations/raw_data/n_circles.csv"
    output_path = "visualizations/plots/n_circles.png"

    df = pd.read_csv(input_path)
    databases = df["Dataset"].tolist()
    circles = df["#Circles"].tolist()
    normalized_circles = df["Normalized #Circles"].astype(float).tolist()

    fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 6), sharey=False)

    colors = plt.cm.viridis(np.linspace(0, 1, len(databases)))

    bars1 = ax1.bar(databases, circles, color=colors, edgecolor="black")

    ax1.set_title("#Circles", fontsize=12)
    ax1.tick_params(axis="x", rotation=30, labelsize=10)
    for label in ax1.get_xticklabels():
        offset = ScaledTranslation(-5 / 72, 0, ax1.figure.dpi_scale_trans)
        label.set_transform(label.get_transform() + offset)

    ax1.tick_params(axis="y", labelsize=10)

    for bar in bars1:
        yval = bar.get_height()
        ax1.text(
            bar.get_x() + bar.get_width() / 2,
            yval + 100000,
            f"{yval:,}",
            ha="center",
            va="bottom",
            fontsize=9,
        )

    bars2 = ax2.bar(databases, normalized_circles, color=colors, edgecolor="black")
    ax2.set_title("Normalized #Circles (%)", fontsize=12)
    ax2.tick_params(axis="x", rotation=30, labelsize=10)
    for label in ax2.get_xticklabels():
        offset = ScaledTranslation(-5 / 72, 0, ax2.figure.dpi_scale_trans)
        label.set_transform(label.get_transform() + offset)

    ax2.tick_params(axis="y", labelsize=10)

    for bar in bars2:
        yval = bar.get_height()
        ax2.text(
            bar.get_x() + bar.get_width() / 2,
            yval + 0.05,
            f"{yval:.2f}%",
            ha="center",
            va="bottom",
            fontsize=9,
        )

    plt.tight_layout()
    plt.subplots_adjust(wspace=0.12)
    plt.savefig(output_path, dpi=300, bbox_inches="tight")


if __name__ == "__main__":
    plot_n_circles()
