
import os
import shutil

# Base directories to scan
base_dirs = ["results/glue", "results/super_glue"]

for base_dir in base_dirs:
    if not os.path.exists(base_dir):
        continue

    for dirpath, dirnames, filenames in os.walk(base_dir):
        # Check if ReadMe.md exists in this folder
        if "ReadMe.md" in filenames:
            # Identify checkpoint directories in this folder
            checkpoints = [d for d in dirnames if d.startswith("checkpoint-")]

            for ckpt in checkpoints:
                ckpt_path = os.path.join(dirpath, ckpt)
                print(f"Deleting checkpoint: {ckpt_path}")
                shutil.rmtree(ckpt_path)

        else:
            # check the change time of the folder
            folder_ctime = os.path.getctime(dirpath)
            # if the folder was changed more than 2 days ago, delete the checkpoint foldeer
            import time
            if time.time() - folder_ctime > 2 * 24 * 60 * 60:
                checkpoints = [d for d in dirnames if d.startswith("checkpoint-")]
                for ckpt in checkpoints:
                    ckpt_path = os.path.join(dirpath, ckpt)
                    print(f"Deleting old checkpoint: {ckpt_path} because folder was changed {(time.time() - folder_ctime) / (24 * 60 * 60)} days ago")
                    shutil.rmtree(ckpt_path)