import json
import os

import numpy as np
from scipy.stats import norm

seat_dir = 'results/seat'
fixed_seat_dir = 'results/seat_fixed'
os.makedirs(fixed_seat_dir, exist_ok=True)

seat_files = [os.path.join(seat_dir, f) for f in os.listdir(seat_dir) if f.endswith('.json')]

tests = ["sent-weat6", "sent-weat6b", "sent-weat7", "sent-weat7b", "sent-weat8", "sent-weat8b"]

n = 1000
confidence_level = 0.95

for seat_file in seat_files:
    with open(seat_file, 'r') as f:
        results = json.load(f)

    results = {k: v for k, v in results.items() if k in tests}

    effect_size = np.mean(np.abs([v['effect_size'] for v in results.values()]))

    effect_abs_sizes = [np.mean([np.abs(v['ci_scores'][i]) for v in results.values()]) for i in range(n)]
    # Step 1: Compute the mean
    mean_score = np.mean(effect_abs_sizes)

    # Step 2: Compute the standard error (SE)
    std_error = np.std(effect_abs_sizes, ddof=1)  # Use ddof=1 for sample std dev
    margin_of_error = norm.ppf(1 - (1 - confidence_level) / 2) * std_error

    main_results = {
        'effect_size': effect_size,
        'ci_abs_scores': effect_abs_sizes,
        'ci_abs_mean': mean_score,
        'ci_margin': margin_of_error,
        **results,
    }

    fixed_seat_file = os.path.join(fixed_seat_dir, os.path.basename(seat_file))
    with open(fixed_seat_file, 'w') as f:
        json.dump(main_results, f, indent=2)