from promptsource.templates import DatasetTemplates

# Load GLUE task (e.g., SST-2)
tasks = ["sst2", "cola", "mrpc", "qqp", "rte", "wnli", "stsb", "mnli", "qnli", ]

for task in tasks:
    prompt_templates = DatasetTemplates("glue", task)

    # List available prompt names
    print(prompt_templates.all_template_names)

    # Use a specific prompt
    prompt = prompt_templates[prompt_templates.all_template_names[0]]

    # Apply it to an example
    example = {"sentence": "I love this movie.", "label": 1}
    input_text, target_text = prompt.apply(example)

    print("Input:", input_text)
    print("Target:", target_text)

    print('--------------------------')