import pandas as pd

models = [
    'bert-base-cased',
    'bert-large-cased',
    'distilbert-base-cased',
    'roberta-large',
    'gpt2',
    'Llama-3.2-3B',
    'Llama-3.2-3B-Instruct',
]

for model in models:

    encoded_file1 = f'results/models/{model}_params_spl_test.csv'
    encoded_file2 = f'results/models/{model}_params_spl_test_v_2.csv'

    df1 = pd.read_csv(encoded_file1)
    df2 = pd.read_csv(encoded_file2)

    df1 = df1[df1['type'] != 'no gender'].reset_index(drop=True)
    df2 = df2[df2['type'] == 'gerneutral'].reset_index(drop=True)

    output = f'results/models/{model}_params_spl_test_v_3.csv'
    pd.concat([df1, df2]).to_csv(output, index=False)
    print(f'Saved merged file to {output}')