import pathlib
import google.generativeai as genai
import json
import tiktoken
import textwrap
import openai
import os
from PIL import Image
import base64
import time
from dotenv import load_dotenv


# Get API key from environment variable
load_dotenv()
openai.api_key = os.getenv("OPENAI_API_KEY")
if not openai.api_key:
    raise ValueError("No OpenAI API key found. Please set the OPENAI_API_KEY.")

# input_reports_path = "../results/clustering/driving/clusters_prompt_ensemble_o4-mini"
input_reports_path = "../results/clustering/waypointnav/clusters_prompt_ensemble_o4-mini"

output_filepath = input_reports_path + "/aggregated_clusters_text.txt"

# Get all txt files in the input_reports_path
report_files = [f for f in os.listdir(input_reports_path) if f.endswith('.txt')]

# Update prompt to request JSON format
prompt_waypoint = """You are given different reports on the failure clusters of a robot navigating indoors based on images. 
Your job is to aggregate these reports, and consolidate them.

Here are the reports:

"""
prompt_driving = """You are given different reports on the failure clusters of car collisions. 
Your job is to aggregate these reports, and consolidate them.

Here are the reports:

"""
prompt = prompt_waypoint if "wayptnav" in input_reports_path else prompt_driving

# Read each report file and add its content to the prompt
for i, report_file in enumerate(report_files):
    file_path = os.path.join(input_reports_path, report_file)
    with open(file_path, 'r') as f:
        report_content = f.read()
    prompt += f"REPORT {i+1}: {report_file}\n{report_content}\n\n"

content = []
content.append({
    "type": "text",
    "text": prompt
})
messages = [{"role": "user", "content": content}]

# Add error handling for the API call

response = openai.ChatCompletion.create(
    model = "o4-mini",
    # response_format={"type": "json_object"},
    messages=messages
)

output = response['choices'][0]['message']['content']


# Save the output to a text file
with open(output_filepath, 'w') as f:
    f.write(output)

# Print to console for immediate feedback
print(f"Output saved to {output_filepath}")
print(output)