import numpy as np
import openai
import base64
import numpy as np
import os
from dotenv import load_dotenv


class Clustering():

    def __init__(self):
        super(Clustering, self).__init__()
        print('Clustering')
        load_dotenv()
        self.api_key = os.getenv("OPENAI_API_KEY")
        if not self.api_key:
            raise ValueError("No OpenAI API key found. Please set the OPENAI_API_KEY.")
        openai.api_key = self.api_key


# PROPOSED PROMPT (WITH KNOWN SEMANTIC FAILURE REASONS)
        self.prompt = """
            You are a runtime failure monitor for the ego car navigating outdoors.  
            Your task is to analyze a sequence of forward-facing camera images ending at the car's current position, and determine whether the car is:  
            a) SAFE — confidently following a collision-free trajectory, or
            b) UNSAFE — likely to collide wth another vehicle or an object
            
            Operational Context:

            - The car must keep on moving without any physical collisions.
            - You are provided with a time-ordered sequence of image frames at 3 frames per second, ending at the car’s current position.
            - Any collision is considered a failure.  
            
            ## Reasoning Procedure:
            
            1. **Trajectory Inference:**  
               From the image sequence, estimate the car’s likely near-future motion: Is it continuing straight, braking, turning, or maneuvering sharply?
            
            2. **Scene Understanding:**  
               Examine the latest image for road layout, obstacles, other vehicles, pedestrians, and environmental conditions.  
               Pay extra attention to:
               - Objects within or near the ego vehicle’s predicted path
               - Occluded or partially visible road users
               - Adverse visibility (glare, fog, night) affecting perception of relevant objects
            
            3. **Collision Risk Assessment:**  
               Determine if a collision is likely. 
               - **Prioritize risks that intersect the ego path**  
               - Ignore objects that are clearly outside the trajectory or do not pose an interaction risk  
            
            4. **Semantic Failure Matching:**
               - You are given a list of **Known Semantic Failure Reasons** of this car (list below) that can lead to collisions. If the current scenario aligns with any of the known failure reasons, mark it unsafe and return the exact name of known failure reason.  
               - If the failure reason does not match a listed type but a collision is likely, briefly describe the new semantic reason.  
               - Return `SAFE` only if you are confident that the car will safely passing through the scene without any possible collision.
               - Err on the side of caution, i.e., failure, when you are not sure.

            Known Semantic Failure Reasons:

            1. Name: Rear-End Collisions: Insufficient Following Distance 
               Keywords: rear-end, following distance, tailgating, braking, delayed reaction, deceleration ahead  
               Description: The vehicle ahead brakes or stops and the ego car fails to leave adequate gap or react in time, leading to a rear-end impact—often exacerbated by poor visibility or road conditions.

            2. Name: Unsafe Cut-In / Lane-Change Intrusions  
               Keywords: lane change, cut-in, merge, encroachment, insufficient clearance, drift, sideswipe  
               Description: Another vehicle abruptly merges or drifts into the ego car’s lane without providing room, cutting off the ego car and causing a collision.

            3. Name: Intersection Right-of-Way Violations 
               Keywords: left turn, yield, right-of-way, red light, signal violation, cross-traffic, stop sign  
               Description: A vehicle fails to yield when turning (especially unprotected left turns) or runs a red/yellow light or stop sign, colliding with lawful through traffic.

            4. Name: Lane Departure & Lateral-Clearance Errors  
               Keywords: lane departure, drift, misjudged gap, narrow lane, lateral clearance, sideswipe  
               Description: The ego car drifts out of its lane or misjudges space beside parked/static vehicles, grazing or sideswiping them.

            5. Name: Visibility-Impaired Perception Failures 
               Keywords: glare, night, rain, fog, wet road, low visibility, windshield occlusion  
               Description: Sun glare, darkness, heavy rain or other occlusions hide a hazard—vehicle, pedestrian or signal—delaying detection and proper reaction.

            6. Name: Pedestrian & Cyclist Detection Failures  
               Keywords: pedestrian, cyclist, bicycle, crosswalk, jaywalking  
               Description: The car fails to detect or yield to a vulnerable road user entering or crossing the roadway, often in a crosswalk or turning path.

            7. Name: Static-Obstacle & Sudden Intrusion Collisions  
               Keywords: parked vehicle, door opening, driveway pull-out, backing/reversing, sudden obstacle  
               Description: A parked car door opens or a vehicle emerges from a driveway/parking stall unexpectedly into the ego car’s path.

            8. Name: Infrastructure & Clearance Errors  
               Keywords: pillar, attenuator, underpass, overpass, vertical clearance, sign structure  
               Description: The ego car clips or crashes into fixed road or bridge infrastructure, or a vehicle’s height exceeds overhead clearance.

            9. Name: Other Rare / Long-Tail Cases 
               Keywords: wrong-way, camera tilt/misalignment, construction equipment, forklift, oversized load, extreme/edge-case  
               Description: Extremely infrequent scenarios such as head-on wrong-way collisions, sensor/camera failures, or rare large obstacles.
                
            ## Output Instructions:
            
            Return only one of the following:
            - Name of a known semantic failure reason (exactly as written above)  
            - A brief description of a new failure type
            - The word SAFE

            Rules:

            - Do not provide explanations, justifications, or degrees of certainty.
            - Output must be a **single, definitive label**: one listed reason, a new concise reason, or SAFE.
            
            """


# PROMPT FOR ABLATION (WITHOUT KNOWN SEMANTIC FAILURE REASONS)
        self.prompt = """
            You are a runtime failure monitor for the ego car navigating outdoors.  
            Your task is to analyze a sequence of forward-facing camera images ending at the car's current position, and determine whether the car is:  
            a) SAFE — confidently following a collision-free trajectory, or
            b) UNSAFE — likely to collide wth another vehicle or an object
            
            Operational Context:

            - The car must keep on moving without any physical collisions.
            - You are provided with a time-ordered sequence of image frames at 3 frames per second, ending at the car’s current position.
            - Any collision is considered a failure.  
            
            ## Reasoning Procedure:
            
            1. **Trajectory Inference:**  
               From the image sequence, estimate the car’s likely near-future motion: Is it continuing straight, braking, turning, or maneuvering sharply?
            
            2. **Scene Understanding:**  
               Examine the latest image for road layout, obstacles, other vehicles, pedestrians, and environmental conditions.  
               Pay extra attention to:
               - Objects within or near the ego vehicle’s predicted path
               - Occluded or partially visible road users
               - Adverse visibility (glare, fog, night) affecting perception of relevant objects
            
            3. **Collision Risk Assessment:**  
               Determine if a collision is likely. 
               - **Prioritize risks that intersect the ego path**  
               - Ignore objects that are clearly outside the trajectory or do not pose an interaction risk  
            
            4. **Semantic Failure Matching:**
               - Return `UNSAFE` if you feel there is a possible collision.
               - Return `SAFE` only if you are confident that the car will safely passing through the scene without any possible collision.
               - Err on the side of caution, i.e., failure, when you are not sure.

            ## Output Instructions:

            - Do not provide explanations, justifications, or degrees of certainty.
            - Output must be a **single word**: SAFE or UNSAFE.
            
            """



    def encode_image_to_base64(self, image_path):
        with open(image_path, 'rb') as img_file:
            return base64.b64encode(img_file.read()).decode('utf-8')

    def cluster(self, images_path, idx):
        content = []
        for i in range(max(0, idx-4), idx+1):
            path = 'frame_00000' + str(i) + '.png'
            print(path)
            base64_image = self.encode_image_to_base64(images_path + '/' + path)
            content.append({
                "type": "image_url",
                "image_url": {
                    "url": f"data:image/jpeg;base64,{base64_image}",
                "detail": "high"
                }
            })

        content.append({
            "type": "text",
            "text": self.prompt
        })
        messages = [{"role": "user", "content": content}]

        response = openai.ChatCompletion.create(
            model = "o4-mini",
            messages=messages,
        )

        output = response['choices'][0]['message']['content']

        return output