# Recourse Matching Framework

This repository implements a three-layer optimization framework for **many-to-many algorithmic recourse** using capacitated bipartite matching. It includes:

* Three optimization approaches:

  1. Initial matching
  2. Best redistribution of capacities
  3. Cost-aware joint optimization of matching and redistribution

## Installation

```bash
pip install -e .
```

Requires Python 3.8+.

### Gurobi License

This project uses the Gurobi Optimizer for solving optimization problems. You will need an active Gurobi license to run the optimization components.

For academic users, a free license can be obtained from: https://www.gurobi.com/academia/academic-program-and-licenses/

## Running Experiments

Use the CLI to run any of the optimization layers:

```bash
python scripts/run_matching.py -f <data_folder> -a <approach> [options]
```

### Arguments:

* `-f`, `--folder`      : Path to the folder with model counterfactuals (required)
* `-a`, `--approach`    : One of `eq1`, `eq2`, `eq3`, or `all` (default: `all`)
* `-g`, `--gamma`       : Gamma parameter for weight function (default: `10`)
* `-b`, `--beta`        : Beta parameter for capacity change penalty (default: `0.03`)
* `-s`, `--seed`        : Random seed for reproducibility (default: `20`)
* `--K`                 : (Optional) Total capacity to allocate
* `--init-cap`          : (Optional) Dictionary of initial capacities, e.g. `"{0:3, 1:2, 2:6, 3:1}"`

### Example Commands

```bash
# Run all equations with default settings
python scripts/run_matching.py -f data/two_moon_infty_norm_MACEe3

# Run with custom initial capacity
python scripts/run_matching.py -f data/credit_one_norm_MACEe3 -g 600 -b 0.05 --init-cap "{0:3, 1:2, 2:6, 3:1}"

# Only run Equation 2 with total capacity 15
python scripts/run_matching.py -f data/adult_l1_norm_MACEe3 -a eq2 --K 15
```

All results and plots will be saved in a structured `results/` directory.

