import numpy as np
from recourse.matching import solve_initial_matching

def optimal_capacity(weights, total_capacity):
    n, m = weights.shape
    max_argmax = [(row.max(), row.argmax()) for row in weights]
    sorted_pairs = sorted(max_argmax, key=lambda x: x[0], reverse=True)[:total_capacity]

    best_capacity = np.zeros(m, dtype=int)
    individual_welfare = 0
    
    for max_val, j in sorted_pairs:
        best_capacity[j] += 1
        individual_welfare += max_val
    
    model, z = solve_initial_matching(weights, best_capacity)
    return best_capacity, individual_welfare, model, z
