import gurobipy as gp
from gurobipy import GRB

def solve_initial_matching(weights, capacity):
    n, m = weights.shape
    
    model = gp.Model("InitialMatching")
    z = {}
    for i in range(n):
        for j in range(m):
            z[i, j] = model.addVar(vtype=GRB.BINARY, name=f"z_{i}_{j}")

    model.setObjective(gp.quicksum(weights[i, j] * z[i, j] for i in range(n) for j in range(m)), GRB.MAXIMIZE)

    for i in range(n):
        model.addConstr(gp.quicksum(z[i, j] for j in range(m)) <= 1, name=f"seeker_{i}")

    for j in range(m):
        model.addConstr(gp.quicksum(z[i, j] for i in range(n)) <= capacity[j], name=f"bank_{j}")

    model.optimize()
    
    return model, z
