
import numpy as np
import random
import os
import glob
import ast

RANDOM_SEED = 20

def load_cost_matrix(folder_path, gamma):
    filepaths = sorted(glob.glob(os.path.join(folder_path, "*.txt")))
    all_samples = set()
    per_model_dicts = []

    for fp in filepaths:
        with open(fp, "r", encoding="utf-8") as f:
            data = ast.literal_eval(f.read())
        per_model_dicts.append(data)
        all_samples.update(data.keys())

    sample_ids = sorted(all_samples)
    n_rows, n_cols = len(sample_ids), len(filepaths)
    costs = np.full((n_rows, n_cols), np.nan, dtype=float)

    for col, model_dict in enumerate(per_model_dicts):
        for row, sid in enumerate(sample_ids):
            if sid in model_dict:
                costs[row, col] = model_dict[sid]["cfe_distance"]

    mask = ~np.isnan(costs).any(axis=1)
    costs = costs[mask]
    weights = np.exp(-gamma * costs)
    
    return costs, weights


def generate_integer_partition(K, m, seed=RANDOM_SEED):
    if seed is not None:
        random.seed(seed)
    breaks = sorted(random.sample(range(1, K), m - 1))
    parts = [a - b for a, b in zip(breaks + [K], [0] + breaks)]
    
    return parts

def generate_random_capacities(total_capacity, m_providers, seed=RANDOM_SEED):
    values = generate_integer_partition(total_capacity, m_providers)
    capacity = {i: v for i, v in enumerate(values)} 
    
    return capacity
