function [L, filter] = get_Laplacian(adj)
deg = sparse(adj) * ones(size(adj, 1),1);

deg = 1./sqrt(deg);
deg(deg==Inf) = 0;
deg(deg==-Inf) = 0;
deg = sparse(diag(deg));
L = (deg * adj * deg);
filter =  sparse((1-0.5)*eye(size(adj, 1)) + 0.5*L);
L =  sparse(eye(size(adj, 1)) - L);
end