# ES-LLM

This repository contains experimental code for fine-tuning Large Language Models (LLMs) using Evolution Strategies (ES). Additionally, we have included Reinforcement Learning (RL) methods like Group Relative Policy Optimization (GRPO).

## Setup
Create a fresh python virtual environment and activate it
```bash
python -m venv es
source es/bin/activate
```

From the root of the repository run following command to install all the relevant python packages
```bash
pip install -e .
```

## Run Finetuning with ES

```bash
python core.py --cf configs/es_llm.yaml
```

## Code Formatting

```bash
black -S -t py39 es_llm && \
flake8 --ignore=E501,E203,W503 es_llm
```


