# orchestrate.py
import click
import subprocess, sys
import time

@click.command()
@click.option('--cf', default="", help='Configuration file to run experiments')
@click.option('--runs', default=1, help='Number of runs')

def run_once(cf, runs):
    for _ in range(runs):
        time.sleep(120)
        try:
            cmd = [
                sys.executable, "-m", "core",
                "--cf", cf,
                "--runs", "1",
            ]
            subprocess.run(cmd, check=True)
        except:
            print("Error running, job skipped...")

if __name__ == "__main__":
    run_once()