from transformers import get_cosine_schedule_with_warmup
from torch.optim.lr_scheduler import LambdaLR

def create_scheduler(name=None, config=None, optimizer=None):
    if name == "cosine_warmup":
        # Hugging Face scheduler
        scheduler = get_cosine_schedule_with_warmup(
            optimizer=optimizer,
            num_warmup_steps=config["num_warmup_steps"],
            num_training_steps=config["num_training_steps"],
        )
    if name is None:
        scheduler = LambdaLR(optimizer, lr_lambda=lambda step: 1.0)
        
    return scheduler

    