from transformers import AutoTokenizer


def create_tokenizer(name, config):
    try:
        if name == "Qwen/Qwen2.5-7B-Instruct":
            tokenizer = AutoTokenizer.from_pretrained(
                name,
                use_fast=config["use_fast"],
                cache_dir=config["hf_cache"],
                return_tensors="pt",
            )

    except:
        raise ValueError(f"Cannot load tokenizer name : {name}")

    return tokenizer
