# ES-LLM

This repository contains experimental code for fine-tuning Large Language Models (LLMs) using Evolution Strategies (ES).

## Usage

```bash
accelerate launch --num_processes 4 --num_machines 1 --machine_rank 0 --mixed_precision bf16 --gpu_ids 0,1,2,3 es_llm_v4.py --gpu_threads=2 --mixed_precision bf16 --model_name=Qwen/Qwen2.5-7B-Instruct
```

Use `--num_processes` to specify the number of GPUs to use, use `--gpu_ids` to specify which GPUs to use (CUDA device id), use `--gpu_threads` to specify the number of threads in each GPU. The total number of parallel evaluations is thereby equal to `num_processes`*`gpu_threads`.

## Other Parameters

- `--model_name`: HuggingFace model to fine-tune
- `--hf_cache_dir`: Directory for HuggingFace cache
- `--verbose`: Enable detailed logging
