#!/usr/bin/env bash
set -uo pipefail   

METHODS=(ga ihl kto npo dpo)
DATASET_SUBSET="${DATASET_SUBSET:-forget05}"

failed=()

for M in "${METHODS[@]}"; do
  echo ">>> Evaluating train_method=$M on subset=$DATASET_SUBSET"
  if ! python run_tofu_unlearn_evaluate.py \
        --model_id open-unlearning/tofu_Llama-2-7b-chat-hf_full \
        --adapter_id "ganeric15/msc_unlearn_lora_${M}_tofu_${DATASET_SUBSET}" \
        --all_epochs \
        "$@"; then
    echo "!!! FAILED: $M"
    failed+=("$M")
    continue
  fi
  echo ">>> Finished $M"
done

if ((${#failed[@]})); then
  echo "Done with errors. Failed methods: ${failed[*]}"
  exit 1
else
  echo "All evaluations complete."
fi

