#!/usr/bin/env bash
set -euo pipefail

# Number of GPUs per run
NPROC="${NPROC:-4}"

# Methods to sweep
METHODS=(npo dpo kto)

for M in "${METHODS[@]}"; do
  echo ">>> Starting train_method=$M"
  torchrun --nproc_per_node="$NPROC" \
    tofu_unlearn.py \
    --model_id tofu_llama-2-7b \
    --model_variant lora \
    --lora_rank 4 \
    --lora_alpha 16 \
    --train_method "$M" \
    --dataset tofu \
    --dataset_split forget10 \
    "$@"
  echo ">>> Finished train_method=$M"
done

echo "All runs complete."

